﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace TravelManagerWeb
{
  public partial class PendingRequests : System.Web.UI.Page
  {
    protected void Page_Load(object sender, EventArgs e)
    {
    }

    protected void ButtonApprove_Click(object sender, EventArgs e)
    {
        ProcessApproval(true, "Zgłoszenie zatwierdzono!");
    }

    protected void ButtonReject_Click(object sender, EventArgs e)
    {
        ProcessApproval(true, "Zgłoszenie odrzucono!");
    }


    protected void ProcessApproval(bool isApproved, string message)
    {
        // Pobieranie identyfikatora zgłoszenia z zaznaczonego wiersza.
      string travelId = this.GridView1.SelectedRow.Cells[1].Text;

      // Do zrobienia: sprawdzanie, czy zgłoszenie nie jest już zatwierdzone lub zamknięte.
      // Przekazywanie danych do czynności Receive w celu ich skorelowania.
      TravelRequestSvc.RequestTravelServiceClient client =
        new TravelRequestSvc.RequestTravelServiceClient();

      // Uruchamianie procesu (przekazywanie zgłoszenia).
      client.ReceiveManagerApproval(travelId, isApproved); 
      client.Close();
      
      ShowResult(message);
    }

    private void ShowResult(string message)
    {
      PanelList.Visible = false;
      LabelResult.Text = message;
      PanelComplete.Visible = true;
    }

    protected void ButtonRefresh_Click(object sender, EventArgs e)
    {
      Response.Redirect("PendingRequests.aspx");
    }

  }
}